/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXINSTALLATION_P_H
#define QKNXINSTALLATION_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt KNX API.  It exists for the convenience
// of the Qt KNX implementation.  This header file may change from version
// to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qdatetime.h>
#include <QtCore/qstring.h>
#include <QtCore/qvector.h>
#include <QtKnx/private/qknxbuildings_p.h>
#include <QtKnx/private/qknxgroupaddresses_p.h>
#include <QtKnx/private/qknxprojectutils_p.h>
#include <QtKnx/private/qknxtopology_p.h>

QT_BEGIN_NAMESPACE

struct Q_KNX_EXPORT QKnxTrade
{
    Q_DECLARE_TR_FUNCTIONS(QKnxTrade)

public:
    QString Id; // optional, non-colonized name, pattern [\i-[:]][\c-[:]]*
    QString Name; // 255 character max.
    QString Number; // optional, 255 character max.
    QString Comment; // optional

    // Undefined, Editing, FinishedDesign, FinishedCommissioning, Tested, Accepted, Locked
    QString CompletionStatus { QLatin1String("Undefined") }; // optional

    QString Description; // optional
    qint32 Puid { 0 };

    QVector<QKnxTrade> Trade; // 0..n
    QVector<QString> DeviceInstanceRef; // 0..n, non-colonized name, pattern [\i-[:]][\c-[:]]*

    bool parseElement(QXmlStreamReader *reader, bool pedantic);
};

struct Q_KNX_EXPORT QKnxSplitInfo
{
    Q_DECLARE_TR_FUNCTIONS(QKnxSplitInfo)

public:
    QString ObjectPath;
    QString Cookie;

    bool parseElement(QXmlStreamReader *reader, bool pedantic);
};

struct Q_KNX_EXPORT QKnxInstallation
{
    Q_DECLARE_TR_FUNCTIONS(QKnxInstallation)

public:
    QString Name; // 50 character max.
    quint16 InstallationId { 0 }; // optional, value max. 15
    quint32 BCUKey { 4294967295 }; //optional

    // pattern ((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])
    QString IPRoutingMulticastAddress { QLatin1String("224.0.23.12") }; // optional

    quint8 MulticastTTL { 16 }; // optional
    QString IPRoutingBackboneKey; // optional, 40 character max.
    quint16 IPRoutingLatencyTolerance { 0 }; // optional
    float IPSyncLatencyFraction { 0.1f }; // optional
    QString DefaultLine; // optional

    // Undefined, Editing, FinishedDesign, FinishedCommissioning, Tested, Accepted, Locked
    QString CompletionStatus { QLatin1String("Undefined") }; // optional

    QString IPRoutingBackboneSecurity { QLatin1String("Auto") }; // optional, Auto, On, Off
    QString SplitType; // optional, None, Master, Split

    QVector<QKnxTopology> Topology; // 1
    QVector<QKnxBuildings> Buildings; // 0..n
    QVector<QKnxGroupAddresses> GroupAddresses; // 1

    QVector<QKnxTrade> Trades; // 0..n
    QVector<QKnxBusAccess> BusAccess; // 0..1
    QVector<QKnxSplitInfo> SplitInfos; // 0..n

    bool parseElement(QXmlStreamReader *reader, bool pedantic);
};

QT_END_NAMESPACE

#endif
